<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the "wrapper" div and all content after.
 *
 * @package Solace
 * @since   1.0.0
 */

/**
 * Executes actions before main tag is closed.
 *
 * @since 1.0.4
 */
do_action( 'solace_before_primary_end' ); ?>

<?php

/**
 * Executes actions after main tag is closed.
 *
 * @since 1.0.4
 */
do_action( 'solace_after_primary' );

/**
 * Filters the content parts.
 *
 * @since 1.0.9
 *
 * @param bool   $status Whether the component should be displayed or not.
 * @param string $context The context name.
 */
if ( apply_filters( 'solace_filter_toggle_content_parts', true, 'footer' ) === true ) {

	/**
	 * Executes actions before the footer was rendered.
	 *
	 * @since 1.0.0
	 */
	do_action( 'solace_before_footer_hook' );

	/**
	 * Executes the rendering function for the footer.
	 *
	 * @since 1.0.0
	 */
	do_action( 'solace_do_footer' );

	/**
	 * Executes actions after the footer was rendered.
	 *
	 * @since 1.0.0
	 */
	do_action( 'solace_after_footer_hook' );
}
?>

</div><!--/.wrapper-->
<?php

wp_footer();

/**
 * Executes actions before the body tag is closed.
 *
 * @since 2.11
 */
do_action( 'solace_body_end_before' );

?>
<div class="box-scroll-to-top">
	<button type="button" class="topbutton" style="background: none; cursor: pointer;">
	<?php 
	//echo get_theme_mod('solace_scroll_to_top','up_arrow1'); 
	$icon_type = get_theme_mod('solace_scroll_to_top','up_arrow1');
	$icon_color = get_theme_mod('solace_scroll_to_top_icon_color','#fff');
	$icon_size = get_theme_mod('solace_scroll_to_top_icon_size','19');
	switch ($icon_type) {
		case 'up_arrow1':
			echo '<svg width="16" height="16" viewBox="0 0 16 16" fill="'.$icon_color.'" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.939 6.11753C13.0131 6.04385 13.0718 5.95627 13.1119 5.85983C13.1519 5.76338 13.1726 5.65997 13.1726 5.55553C13.1726 5.45109 13.1519 5.34768 13.1119 5.25124C13.0718 5.15479 13.0131 5.06721 12.939 4.99353L8.17904 0.233531C8.10536 0.159515 8.01778 0.100783 7.92134 0.0607066C7.82489 0.0206305 7.72148 0 7.61704 0C7.51261 0 7.40919 0.0206305 7.31275 0.0607066C7.2163 0.100783 7.12873 0.159515 7.05504 0.233531L2.29504 4.99453C2.22124 5.06833 2.1627 5.15595 2.12276 5.25238C2.08281 5.34881 2.06226 5.45216 2.06226 5.55653C2.06226 5.6609 2.08281 5.76426 2.12276 5.86068C2.1627 5.95711 2.22124 6.04473 2.29504 6.11853C2.36885 6.19233 2.45646 6.25088 2.55289 6.29082C2.64932 6.33076 2.75267 6.35132 2.85704 6.35132C2.96142 6.35132 3.06477 6.33076 3.1612 6.29082C3.25762 6.25088 3.34524 6.19233 3.41904 6.11853L7.61904 1.91853L11.819 6.11853C11.8927 6.19255 11.9803 6.25128 12.0767 6.29136C12.1732 6.33143 12.2766 6.35206 12.381 6.35206C12.4855 6.35206 12.5889 6.33143 12.6853 6.29136C12.7818 6.25128 12.8694 6.19255 12.943 6.11853L12.939 6.11753Z" fill="'.$icon_color.'"/><path fill-rule="evenodd" clip-rule="evenodd" d="M7.618 12.6974C7.82832 12.6974 8.03002 12.6139 8.17874 12.4652C8.32745 12.3164 8.411 12.1147 8.411 11.9044V1.58842C8.411 1.37797 8.3274 1.17614 8.17859 1.02733C8.02978 0.878523 7.82795 0.794922 7.6175 0.794922C7.40705 0.794922 7.20522 0.878523 7.05641 1.02733C6.9076 1.17614 6.824 1.37797 6.824 1.58842V11.9044C6.824 12.0086 6.84454 12.1118 6.88446 12.2081C6.92437 12.3044 6.98287 12.3919 7.05662 12.4655C7.13036 12.5392 7.2179 12.5976 7.31423 12.6373C7.41055 12.6771 7.51378 12.6976 7.618 12.6974ZM0 15.2374C0.000527434 15.0692 0.0675987 14.908 0.18657 14.789C0.305542 14.67 0.46675 14.6029 0.635 14.6024H14.6C14.7684 14.6024 14.9299 14.6693 15.049 14.7884C15.1681 14.9075 15.235 15.069 15.235 15.2374C15.235 15.4058 15.1681 15.5673 15.049 15.6864C14.9299 15.8055 14.7684 15.8724 14.6 15.8724H0.635C0.466588 15.8724 0.305073 15.8055 0.185987 15.6864C0.0669019 15.5673 0 15.4058 0 15.2374Z" fill="'.$icon_color.'"/></svg>';
			break;
		case 'up_arrow2':
			echo '<svg width="23" height="24" version="1.1" id="icons_1_" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 128 128" style="enable-background:new 0 0 128 128" xml:space="preserve"><style>.st0{display:none}.st1{display:inline}.st2{fill:'.$icon_color.'}</style><g id="row2_1_"><g id="_x34__3_"><path class="st2" d="M64 .3C28.7.3 0 28.8 0 64s28.7 63.7 64 63.7 64-28.5 64-63.7S99.3.3 64 .3zm0 121C32.2 121.3 6.4 95.7 6.4 64 6.4 32.3 32.2 6.7 64 6.7s57.6 25.7 57.6 57.3c0 31.7-25.8 57.3-57.6 57.3zM38.4 58.9V66c0 2.2 1.8 3.9 3.9 3.9l15.3-12.2v28.7c0 2.2 2.3 3.2 4.4 3.2h4c2.2 0 3.9-1.8 3.9-3.9V57.2l15.8 12.7c2.2 0 3.9-1.8 3.9-3.9v-7.1L64 32.2 38.4 58.9z" id="up"/></g></g></svg>';
			break;
		case 'up_arrow3':
			echo '<svg width="23" height="22" viewBox="0 0 23 22" fill="'.$icon_color.'" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M22.045 11.0001C22.045 13.0857 21.4265 15.1244 20.2678 16.8586C19.1091 18.5927 17.4622 19.9443 15.5354 20.7424C13.6085 21.5405 11.4883 21.7493 9.44273 21.3425C7.3972 20.9356 5.51826 19.9313 4.04352 18.4565C2.56878 16.9818 1.56446 15.1028 1.15758 13.0573C0.750699 11.0118 0.959525 8.89153 1.75765 6.96468C2.55578 5.03783 3.90736 3.39093 5.64147 2.23223C7.37559 1.07353 9.41436 0.455078 11.5 0.455078C14.2967 0.455078 16.9788 1.56607 18.9564 3.54364C20.934 5.52121 22.045 8.20337 22.045 11.0001ZM8.01196 11.4661C7.88708 11.584 7.72112 11.6486 7.54936 11.6462C7.3776 11.6437 7.21357 11.5744 7.0921 11.4529C6.97064 11.3315 6.90131 11.1674 6.89886 10.9957C6.89641 10.8239 6.96102 10.658 7.07896 10.5331L11.033 6.57908C11.0942 6.51773 11.1669 6.46906 11.2469 6.43585C11.327 6.40264 11.4128 6.38554 11.4995 6.38554C11.5861 6.38554 11.6719 6.40264 11.752 6.43585C11.832 6.46906 11.9047 6.51773 11.966 6.57908L15.92 10.5331C15.9841 10.5937 16.0355 10.6665 16.071 10.7473C16.1065 10.8281 16.1255 10.9152 16.1267 11.0035C16.128 11.0917 16.1115 11.1793 16.0783 11.2611C16.0452 11.3429 15.9959 11.4172 15.9335 11.4796C15.8711 11.542 15.7968 11.5913 15.715 11.6245C15.6332 11.6577 15.5456 11.6741 15.4574 11.6728C15.3691 11.6716 15.282 11.6526 15.2012 11.6171C15.1204 11.5816 15.0476 11.5302 14.987 11.4661L12.155 8.63708V14.9551C12.155 15.1299 12.0855 15.2975 11.9619 15.4211C11.8384 15.5446 11.6707 15.6141 11.496 15.6141C11.3212 15.6141 11.1536 15.5446 11.03 15.4211C10.9064 15.2975 10.837 15.1299 10.837 14.9551V8.63708L8.01196 11.4661Z" fill="'.$icon_color.'"/>
			</svg>
			';
			break;
		case 'up_arrow4':
			echo '<svg width="21" height="20" viewBox="0 0 21 20" fill="'.$icon_color.'" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M17.976 1.27823H3.02398C2.69352 1.27823 2.3766 1.4095 2.14293 1.64317C1.90926 1.87684 1.77798 2.19377 1.77798 2.52423V17.4762C1.77798 17.8067 1.90926 18.1236 2.14293 18.3573C2.3766 18.591 2.69352 18.7222 3.02398 18.7222H17.976C18.3064 18.7222 18.6234 18.591 18.857 18.3573C19.0907 18.1236 19.222 17.8067 19.222 17.4762V2.52423C19.222 2.19377 19.0907 1.87684 18.857 1.64317C18.6234 1.4095 18.3064 1.27823 17.976 1.27823ZM3.02398 0.0322266C2.36306 0.0322266 1.72921 0.294776 1.26187 0.762116C0.794532 1.22946 0.531982 1.86331 0.531982 2.52423L0.531982 17.4762C0.531982 18.1371 0.794532 18.771 1.26187 19.2383C1.72921 19.7057 2.36306 19.9682 3.02398 19.9682H17.976C18.6369 19.9682 19.2708 19.7057 19.7381 19.2383C20.2054 18.771 20.468 18.1371 20.468 17.4762V2.52423C20.468 1.86331 20.2054 1.22946 19.7381 0.762116C19.2708 0.294776 18.6369 0.0322266 17.976 0.0322266L3.02398 0.0322266Z" fill="'.$icon_color.'"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M6.32197 10.4416C6.37983 10.4996 6.44857 10.5456 6.52424 10.577C6.59992 10.6084 6.68104 10.6246 6.76297 10.6246C6.84489 10.6246 6.92601 10.6084 7.00169 10.577C7.07736 10.5456 7.1461 10.4996 7.20397 10.4416L10.504 7.14162L13.804 10.4416C13.8612 10.5027 13.93 10.5516 14.0065 10.5855C14.083 10.6194 14.1655 10.6376 14.2492 10.6389C14.3328 10.6403 14.4159 10.6248 14.4934 10.5934C14.571 10.5621 14.6414 10.5154 14.7006 10.4562C14.7597 10.3971 14.8064 10.3266 14.8378 10.2491C14.8692 10.1715 14.8846 10.0885 14.8833 10.0048C14.8819 9.92118 14.8637 9.83867 14.8298 9.76218C14.7959 9.6857 14.747 9.61681 14.686 9.55962L10.948 5.82162C10.8901 5.76362 10.8214 5.71762 10.7457 5.68622C10.67 5.65483 10.5889 5.63867 10.507 5.63867C10.425 5.63867 10.3439 5.65483 10.2682 5.68622C10.1926 5.71762 10.1238 5.76362 10.066 5.82162L6.32796 9.55962C6.26997 9.61749 6.22396 9.68622 6.19257 9.7619C6.16118 9.83757 6.14502 9.91869 6.14502 10.0006C6.14502 10.0825 6.16118 10.1637 6.19257 10.2393C6.22396 10.315 6.26997 10.3837 6.32796 10.4416H6.32197Z" fill="'.$icon_color.'"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M10.502 14.3617C10.6673 14.3617 10.8257 14.2961 10.9426 14.1792C11.0594 14.0624 11.125 13.9039 11.125 13.7387V7.5107C11.125 7.42888 11.1089 7.34787 11.0776 7.27228C11.0463 7.1967 11.0004 7.12802 10.9426 7.07017C10.8847 7.01232 10.816 6.96643 10.7404 6.93512C10.6649 6.90381 10.5838 6.8877 10.502 6.8877C10.4202 6.8877 10.3392 6.90381 10.2636 6.93512C10.188 6.96643 10.1194 7.01232 10.0615 7.07017C10.0036 7.12802 9.95776 7.1967 9.92645 7.27228C9.89514 7.34787 9.87903 7.42888 9.87903 7.5107V13.7407C9.87956 13.9056 9.94543 14.0635 10.0622 14.1799C10.179 14.2963 10.3371 14.3617 10.502 14.3617Z" fill="'.$icon_color.'"/>
			</svg>';
			break;
		case 'up_arrow5':
			echo '<svg width="20" height="20" viewBox="0 0 20 20" fill="'.$icon_color.'" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.879 0.386719L19.758 10.2657H15.148V19.4867H4.61V10.2657H0L9.879 0.386719Z" fill="'.$icon_color.'"/>
			</svg>
			';
			break;
		default:
			echo '<svg width="16" height="16" viewBox="0 0 16 16" fill="'.$icon_color.'" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.939 6.11753C13.0131 6.04385 13.0718 5.95627 13.1119 5.85983C13.1519 5.76338 13.1726 5.65997 13.1726 5.55553C13.1726 5.45109 13.1519 5.34768 13.1119 5.25124C13.0718 5.15479 13.0131 5.06721 12.939 4.99353L8.17904 0.233531C8.10536 0.159515 8.01778 0.100783 7.92134 0.0607066C7.82489 0.0206305 7.72148 0 7.61704 0C7.51261 0 7.40919 0.0206305 7.31275 0.0607066C7.2163 0.100783 7.12873 0.159515 7.05504 0.233531L2.29504 4.99453C2.22124 5.06833 2.1627 5.15595 2.12276 5.25238C2.08281 5.34881 2.06226 5.45216 2.06226 5.55653C2.06226 5.6609 2.08281 5.76426 2.12276 5.86068C2.1627 5.95711 2.22124 6.04473 2.29504 6.11853C2.36885 6.19233 2.45646 6.25088 2.55289 6.29082C2.64932 6.33076 2.75267 6.35132 2.85704 6.35132C2.96142 6.35132 3.06477 6.33076 3.1612 6.29082C3.25762 6.25088 3.34524 6.19233 3.41904 6.11853L7.61904 1.91853L11.819 6.11853C11.8927 6.19255 11.9803 6.25128 12.0767 6.29136C12.1732 6.33143 12.2766 6.35206 12.381 6.35206C12.4855 6.35206 12.5889 6.33143 12.6853 6.29136C12.7818 6.25128 12.8694 6.19255 12.943 6.11853L12.939 6.11753Z" fill="'.$icon_color.'"/><path fill-rule="evenodd" clip-rule="evenodd" d="M7.618 12.6974C7.82832 12.6974 8.03002 12.6139 8.17874 12.4652C8.32745 12.3164 8.411 12.1147 8.411 11.9044V1.58842C8.411 1.37797 8.3274 1.17614 8.17859 1.02733C8.02978 0.878523 7.82795 0.794922 7.6175 0.794922C7.40705 0.794922 7.20522 0.878523 7.05641 1.02733C6.9076 1.17614 6.824 1.37797 6.824 1.58842V11.9044C6.824 12.0086 6.84454 12.1118 6.88446 12.2081C6.92437 12.3044 6.98287 12.3919 7.05662 12.4655C7.13036 12.5392 7.2179 12.5976 7.31423 12.6373C7.41055 12.6771 7.51378 12.6976 7.618 12.6974ZM0 15.2374C0.000527434 15.0692 0.0675987 14.908 0.18657 14.789C0.305542 14.67 0.46675 14.6029 0.635 14.6024H14.6C14.7684 14.6024 14.9299 14.6693 15.049 14.7884C15.1681 14.9075 15.235 15.069 15.235 15.2374C15.235 15.4058 15.1681 15.5673 15.049 15.6864C14.9299 15.8055 14.7684 15.8724 14.6 15.8724H0.635C0.466588 15.8724 0.305073 15.8055 0.185987 15.6864C0.0669019 15.5673 0 15.4058 0 15.2374Z" fill="'.$icon_color.'"/></svg>';
	}


	?>
		<span style="display: none;"><?php esc_html_e( 'scroll to top', 'solace' ); ?></span>
	</button>
</div>
</body>

</html>
